; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               Language-File Creator
; -----------------------------------------------------------------------------
; Version:            0.1
; Date:               2005-10-01
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

#SingleInstance force
SetBatchLines, -1
SetWorkingDir, ..

StringRight, Lng, A_Language, 2 ; Sprache ermitteln

If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   ScriptName       = Sprachdatei erstellen
   lng_SelectSource = Welche Sprache als Ausgangssprache verwenden
   lng_Source1      = Originalsprache (Deutsch)
   lng_Source2      = Alternativsprache (Englisch)
   lng_Destination  = Zielsprache
   lng_OK           = &OK
   lng_Cancel       = A&bbrechen
   lng_OverwriteVars= vorhandene Datei berschreiben
   lng_UpdateVars   = Neue Variablen hinzufgen und vorhandene aktualisieren
   lng_OnlyNewVars  = Nur neue Variablen hinzufgen
   Languages = Deutsch||English|Dutch|French|Italian|Russian

}
else        ; = other languages (english)
{
   ScriptName       = Language-file creator
   lng_SelectSource = which language should be used as source
   lng_Source1      = original language (german)
   lng_Source2      = alternative language (english)
   lng_Destination  = destination language
   lng_OK           = &OK
   lng_Cancel       = &Cancel
   lng_OverwriteVars= overwrite existing file
   lng_UpdateVars   = refresh variables and add new ones
   lng_OnlyNewVars  = only add new variables
   Languages = German|English||Dutch|French|Italian|Russian
}

Gui, Add, Text, , %lng_SelectSource%:
Gui, Add, DropDownlist, w300 AltSubmit vSource, %lng_Source1%||%lng_Source2%

Gui, Add, Text, , %lng_Destination%:
Gui, Add, DropDownlist,vDestination, %Languages%

Gui, Add, Radio, vOverwriteNew Checked, %lng_OverwriteVars%
Gui, Add, Radio, vUpdateNew, %lng_UpdateVars%
Gui, Add, Radio, vOnlyNew, %lng_OnlyNewVars%

Gui, Add, Button, y+5 xs+40 w100 gOK, %lng_OK%
Gui, Add, Button, x+10 w100 gCancel, %lng_Cancel%


Gui, Show, AutoSize, %ScriptName%

Return

OK:
   Gui, Submit
   Gui, Destroy
   DestFile = development\language_%Destination%.ini

   DestFileIntro =

   If OverwriteNew = 1
      FileDelete, %DestFile%

   IfExist, %DestFile%
   {
      Loop, Read, %DestFile%, %DestFile%.tmp
      {
         ReadLine = %A_LoopReadLine%
         If ( StrLeft(A_LoopReadLine, 3) = "`; [" )
            StringTrimLeft, ReadLine, ReadLine, 2
         FileAppend, %ReadLine%`r`n
      }
      FileMove, %DestFile%.tmp, %DestFile%, 1
   }
   Else
      DestFileIntro = `; Language-file for ac'tivAid: %Destination%`r`n

   Loop, *.ahk, 0 ,1
   {
      IfInString, A_LoopFilefullpath, backups\
         continue
      IfInString, A_LoopFilefullpath, development\
         continue
      IfInString, A_LoopFilefullpath, DEV\
         continue

      If A_LoopFileName = %A_ScriptName%
         continue
      If A_LoopFileName = ac'tivAid_AHK-Checker.ahk
         continue
      If A_LoopFileName = test.ahk
         continue
      If A_LoopFileName = dev_NEXTbuild.ahk
         continue
      IfInstring, A_LoopFileName, bench-
         continue
      If (StrLeft(A_LoopFileName,1) = "_")
         continue

      FileName = %A_Loopfilename%

      FilePath = %A_Loopfilefullpath%
      Step =
      Prefix =
      Loop, Read, %FilePath%
      {
         If A_LoopReadLine =
            continue
         StringReplace, ReadLine, A_LoopReadLine, %A_Space%,,All

         If (StrLeft(ReadLine,1)=";")
            continue

         If Step =
         {
            IfInString, ReadLine, ScriptName=activAid
            {
               Step = 0.6
               Section = activAid
               continue
            }

            IfNotInString, ReadLine, Prefix=
               continue
            Step = 0.5
            StringSplit, ReadLine, ReadLine, =
            Prefix = %ReadLine2%
         }
         If Step = 0.5
         {
            IfNotInString, ReadLine, `%Prefix`%_ScriptName=
               continue
            Step = 0.6
            StringSplit, ReadLine, ReadLine, =
            Section = %ReadLine2%
         }
         If Step = 0.6
         {
            IfInString, ReadLine, IfLng=07
               Step = 1
            continue
         }

         If Step = 1
         {
            If Source = 1
               Step = 2
            Else
               Step = 3
            continue
         }

         If Step = 3
         {
            IfInString, A_LoopReadLine, Else
            {
               IfInString, A_LoopReadLine, If
                  continue
               Step = 2
            }
            continue
         }

         If Step = 2
         {
            If ReadLine = {
               continue
            If ReadLine = }
            {
               Step =
               Prefix =
               continue
            }

            StringGetPos, Pos, A_LoopReadLine, =
            StringLeft, Key, A_LoopReadLine, % Pos
            Key = %Key%
            If ( (Key = "MenuName" OR Key = "Description") AND Prefix <> "" )
               Key = %Prefix%_%Key%
            StringTrimLeft, Value, A_LoopReadLine, % Pos+1
            Value = %Value%
            If OverwriteNew = 0
            {
               IniRead, DestValue, %DestFile%, %Section%, %Key%

               If DestValue = ERROR
                  Value = %Value%  `; *NEW*
               Else If OnlyNew = 1
                  Value = %DestValue%

            }
            IniWrite, %Value%, %DestFile%, %Section%, %Key%
         }
      }
   }
   Gosub, sub_BeautifyINI
   Msgbox, Ok
   ExitApp
Return

; INI-Datei verschnern
sub_BeautifyINI:
   FileDelete, %DestFile%.tmp
   DestFileNewContent = %DestFileIntro%
   FileRead, DestFileContent, %DestFile%
   Loop, Parse, DestFileContent, `n, `r
   {
      If A_LoopField =
         continue

      If A_LoopField = `;____________________________________________________________________________
         continue

      If A_LoopField = `;
         continue

      If ( StrLeft(A_LoopField,1) = "[" )
      {
         DestFileNewContent = %DestFileNewContent%`r`n`;____________________________________________________________________________`r`n
         DestFileNewContent = %DestFileNewContent%`; %A_LoopField%`r`n
         DestFileNewContent = %DestFileNewContent%`;`r`n
         continue
      }

      StringGetPos, ReadLinePos, A_LoopField, =
      StringLeft, Key, A_LoopField, % ReadLinePos
      Key = %Key%
      StringTrimLeft, Value, A_LoopField, % ReadLinePos+1
      Value = %Value%

      StringLen, KeyLen, Key
      ReadLinePos := 32-KeyLen
      ReadLineIndent := "                                                    = "
      StringRight, ReadLineIndent, ReadLineIndent, %ReadLinePos%
      IfNotInstring, A_LoopField, =
         ReadLine := A_LoopField
      Else
         ReadLine := Key ReadLineIndent Value
      DestFileNewContent = %DestFileNewContent%%ReadLine%`r`n
   }
   FileAppend, %DestFileNewContent%, %DestFile%.tmp

   FileMove, %DestFile%.tmp, %DestFile%, 1
Return


GuiEscape:
GuiClose:
Cancel:
   ExitApp
Return

StrLeft(String,Len)
{
   StringLeft, Output, String, %Len%
   Return Output
}

